package com.ejie.aa17a.dao.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aDatoHistoricoDao;
import com.ejie.aa17a.model.Aa17aBanda;
import com.ejie.aa17a.model.Aa17aContaminante;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * Aa17aDatoHistoricoDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aDatoHistoricoDaoImpl implements Aa17aDatoHistoricoDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<BigDecimal[]> rwMap = new RowMapper<BigDecimal[]>() {
		public BigDecimal[] mapRow(ResultSet resultSet, int rowNum)
					throws SQLException {

			BigDecimal[] datos = new BigDecimal[2];
			datos[0] = new BigDecimal(Aa17aFuncionesComunes.getDateHora(resultSet.getDate("FECHADATO")).getTime());
			datos[1] = resultSet.getBigDecimal("VALORDIARIO");
			return datos;

		}
	};

	private RowMapper<Aa17aDatoHistorico> rwMapHistorico = new RowMapper<Aa17aDatoHistorico>() {
		public Aa17aDatoHistorico mapRow(ResultSet resultSet, int rowNum)
					throws SQLException {

			Aa17aDatoHistorico datoHistorico = new Aa17aDatoHistorico();

			datoHistorico.setFechaDato(resultSet.getDate("FECHADATO"));
			datoHistorico.setValorDiario(resultSet.getBigDecimal("VALORDIARIO"));

			Aa17aContaminante contaminante = new Aa17aContaminante();
			contaminante.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));
			contaminante.setNombreContaminante(resultSet.getString("NOMBRE_CONTAMINANTE"));
			contaminante.setUnidadMedida(resultSet.getString("UNIDAD_MEDIDA"));
			datoHistorico.setContaminante(contaminante);

			Aa17aBanda banda = new Aa17aBanda();
			banda.setIdBanda(resultSet.getLong("IDBANDA"));
			datoHistorico.setBanda(banda);

			datoHistorico.setIdEstacion(resultSet.getLong("IDESTACION"));

			return datoHistorico;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve los datos historicos para cargar el grafico
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List<BigDecimal[]>
	 */
	@Transactional(readOnly = true)
	public List<BigDecimal[]> getDatosHistorico(Aa17aDatoHistorico aa17adatohistorico) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T08_FECHA FECHADATO, t1.T08_VALOR_DIARIO VALORDIARIO ");
		query.append("FROM AA17A.AA1708S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17adatohistorico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY FECHADATO ASC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<BigDecimal[]>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Devuelve los datos historicos en una lista de beans
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List<Aa17aDatoHistorico>
	 */
	@Transactional(readOnly = true)
	public List<Aa17aDatoHistorico> listDatosHistoricos(Aa17aDatoHistorico aa17adatohistorico) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT  t1.T08_FECHA FECHADATO, t1.T08_VALOR_DIARIO VALORDIARIO, ");
		query.append(" t1.T02_CONTAMINANTE_ID IDCONTAMINANTE, AA1702S00.T02_NOMBRE NOMBRE_CONTAMINANTE, ");
		query.append(" AA1702S00.T02_UNIDAD_MEDIDA UNIDAD_MEDIDA, ");
		query.append(" t1.T01_ESTACION_ID IDESTACION, ");
		query.append(" t1.T04_BANDA_ID IDBANDA ");

		query.append(" FROM AA17A.AA1708S00 t1 ");
		query.append(" INNER JOIN AA1702S00 ON AA1702S00.T02_CONTAMINANTE_ID = t1.T02_CONTAMINANTE_ID ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17adatohistorico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY FECHADATO ASC, NOMBRE_CONTAMINANTE ASC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aDatoHistorico>) this.jdbcTemplate.query(
				query.toString(), this.rwMapHistorico, params.toArray());
	}

	/**
	 * Devuelve el máximo idBanda del dia anterior al actual de los datos
	 * historicos de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getMaxIdBandaEstacion(Long idEstacion) {

		StringBuilder query = new StringBuilder();
		query.append(" SELECT MAX(T04_BANDA_ID) IDBANDA FROM AA1708S00 ");
		query.append(" WHERE T08_FECHA = TO_DATE(TO_CHAR(SYSDATE - 1,'DD/MM/YYYY'),'DD/MM/YYYY') ");
		query.append(" AND T01_ESTACION_ID = ?");

		try {
			return this.jdbcTemplate.queryForLong(query.toString(), idEstacion);
		} catch (DataAccessException e) {
			return null;
		}
	}

	/**
	 * Devuelve el idBanda del dia anterior al actual de los datos historicos de
	 * una estacion y un contaminante
	 * 
	 * @param datoHistorico
	 *            Aa17aDatoHistorico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getIdBandaContaminante(Aa17aDatoHistorico datoHistorico) {

		StringBuilder query = new StringBuilder();
		query.append(" SELECT T04_BANDA_ID IDBANDA FROM AA1708S00 ");
		query.append(" WHERE T08_FECHA = TO_DATE(TO_CHAR(SYSDATE - 1,'DD/MM/YYYY'),'DD/MM/YYYY') ");
		query.append(" AND T01_ESTACION_ID = ?");
		query.append(" AND T02_CONTAMINANTE_ID = ?");

		List<Object> params = new ArrayList<Object>();
		params.add(datoHistorico.getIdEstacion());
		params.add(datoHistorico.getContaminante().getIdContaminante());

		try {
			return this.jdbcTemplate.queryForLong(query.toString(), datoHistorico.getIdEstacion(), datoHistorico.getContaminante().getIdContaminante());
		} catch (DataAccessException e) {
			return null;
		}

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aDatoHistorico entity
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aDatoHistorico aa17adatohistorico) {

		StringBuffer where = new StringBuffer(
				Aa17aDatoHistoricoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17adatohistorico != null
				&& aa17adatohistorico.getIdEstacion() != null) {
			where.append(" AND t1.T01_ESTACION_ID = ?");
			params.add(aa17adatohistorico.getIdEstacion());
		}
		if (aa17adatohistorico != null
				&& aa17adatohistorico.getContaminante() != null
				&& aa17adatohistorico.getContaminante().getIdContaminante() != null) {
			where.append(" AND t1.T02_CONTAMINANTE_ID = ?");
			params.add(aa17adatohistorico.getContaminante().getIdContaminante());
		}
		if (aa17adatohistorico != null
				&& aa17adatohistorico.getFechaDato() != null) {
			where.append(" AND t1.T08_FECHA = ?");
			params.add(aa17adatohistorico.getFechaDato());
		}

		if (aa17adatohistorico != null && aa17adatohistorico.getFechaDesde() != null) {
			where.append(" AND t1.T08_FECHA >= ?");
			params.add(aa17adatohistorico.getFechaDesde());
		}

		if (aa17adatohistorico != null && aa17adatohistorico.getFechaHasta() != null) {
			where.append(" AND t1.T08_FECHA <= ?");
			params.add(Aa17aFuncionesComunes.getDateHora(aa17adatohistorico.getFechaHasta()));
		}

		if (aa17adatohistorico != null
				&& aa17adatohistorico.getValorDiario() != null) {
			where.append(" AND t1.T08_VALOR_DIARIO = ?");
			params.add(aa17adatohistorico.getValorDiario());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
